//
//  MCPGServer+Replication.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-23.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCPostgresPersistence/MCPGServer.h>
#import <MCPostgresPersistence/MCPGDatabase.h>

#import <MCClientServer/MCClientServerDefines.h>

#import <MCFoundation/MCPDatabaseConnection.h>
#import <MCFoundation/MCPGenericObject.h>
#import <MCFoundation/MCPUserProtocol.h>

extern NSString *kMCSReplicaDetailsDefaultsKey;


extern inline NSString *MCSReplicaKeychainPass(MCPGServer *server);


@interface MCPGServer (MCSCredentialStorage)
- (NSMutableDictionary *)loadInfoForReplica:(NSString *)replicaName;
- (void)updateInfo:(NSDictionary *)info forReplica:(NSString *)replicaName;
- (MCSAuthenticationErrorCode)authenticationErrorForReplica:(NSString *)replicaName;
- (void)setAuthenticationError:(MCSAuthenticationErrorCode)code forReplica:(NSString *)replicaName;
- (NSString *)replicationKeychainPath;
- (BOOL)doesReplicationKeychainExist;
- (BOOL)deleteReplicationKeychain:(NSError **)error;
- (BOOL)loadPassword:(NSString **)password username:(NSString **)username database:(NSString *)dbName;
- (BOOL)savePassword:(NSString *)password forUsername:(NSString *)username address:(NSString *)address database:(NSString *)dbName;
- (void)saveUsername:(NSString *)username serverURL:(NSURL *)serverURL forReplica:(NSString *)replicaName;
- (NSURL *)serverURLForDatabase:(NSString *)dbName; // reads it from the replica info
- (NSString *)lastUsedServerHostAddress;
- (void)setLastUsedServerHostAddress:(NSString *)anAddress;
@end


// These will be over-ridden app-specifically, if necessary (i.e. in Daylite, but not in Billings Pro)
@interface MCPDatabaseConnection (MCSTouchStage)
- (BOOL)checkIfObjectsPlayingDead; // if YES, will call -shouldTreatAsDeleted: as necessary
- (BOOL)shouldTreatAsDeleted:(MCPGenericObject *)anObject;
@end


// These are implemented in the relevant DBMS-specific persistence framework
@interface MCPDatabaseConnection (MCSReplication)
- (NSDictionary *)replicaConfigDictionary;
- (void)setConnectionValue:(id)value forKey:(NSString *)aKey;
- (BOOL)checkConnection;
- (id<MCPUserProtocol>)userNamed:(NSString *)username;
@end


